/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import de.johni0702.minecraft.bobby.mixin.BiomeAccessAccessor;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2487;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3545;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class FakeChunkManager {
    private static final String FALLBACK_LEVEL_NAME = "bobby-fallback";
    private static final class_310 client = class_310.method_1551();
    private final class_638 world;
    private final class_631 clientChunkManager;
    private final ClientChunkManagerExt clientChunkManagerExt;
    private final FakeChunkStorage storage;
    @Nullable
    private final FakeChunkStorage fallbackStorage;
    private int ticksSinceLastSave;
    private final Long2ObjectMap<class_2818> fakeChunks = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final VisibleChunksTracker chunkTracker = new VisibleChunksTracker();
    private final Long2LongMap toBeUnloaded = new Long2LongOpenHashMap();
    private final Deque<class_3545<Long, Long>> unloadQueue = new ArrayDeque<class_3545<Long, Long>>();
    private static final ExecutorService loadExecutor = Executors.newFixedThreadPool(8, (ThreadFactory)new DefaultThreadFactory("bobby-loading", true));
    private final Long2ObjectMap<LoadingJob> loadingJobs = new Long2ObjectOpenHashMap();

    public FakeChunkManager(class_638 world, class_631 clientChunkManager) {
        this.world = world;
        this.clientChunkManager = clientChunkManager;
        this.clientChunkManagerExt = (ClientChunkManagerExt)clientChunkManager;
        long seedHash = ((BiomeAccessAccessor)world.method_22385()).getSeed();
        class_5321 worldKey = world.method_27983();
        class_2960 worldId = worldKey.method_29177();
        Path storagePath = FakeChunkManager.client.field_1697.toPath().resolve(".bobby").resolve(FakeChunkManager.getCurrentWorldOrServerName()).resolve("" + seedHash).resolve(worldId.method_12836()).resolve(worldId.method_12832());
        this.storage = FakeChunkStorage.getFor(storagePath, true);
        FakeChunkStorage fallbackStorage = null;
        class_32 levelStorage = client.method_1586();
        if (levelStorage.method_230(FALLBACK_LEVEL_NAME)) {
            try (class_32.class_5143 session = levelStorage.method_27002(FALLBACK_LEVEL_NAME);){
                Path worldDirectory = session.method_27424(worldKey);
                Path regionDirectory = worldDirectory.resolve("region");
                fallbackStorage = FakeChunkStorage.getFor(regionDirectory, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fallbackStorage = fallbackStorage;
    }

    public class_2818 getChunk(int x, int z) {
        return (class_2818)this.fakeChunks.get(class_1923.method_8331((int)x, (int)z));
    }

    public FakeChunkStorage getStorage() {
        return this.storage;
    }

    public void update(boolean blocking, BooleanSupplier shouldKeepTicking) {
        class_3545<Long, Long> next;
        class_746 player;
        if (++this.ticksSinceLastSave > 1200) {
            class_156.method_27958().execute(() -> ((FakeChunkStorage)this.storage).method_23697());
            this.ticksSinceLastSave = 0;
        }
        if ((player = FakeChunkManager.client.field_1724) == null) {
            return;
        }
        BobbyConfig config = Bobby.getInstance().getConfig();
        long time = class_156.method_658();
        class_1923 playerChunkPos = player.method_31476();
        int newCenterX = playerChunkPos.field_9181;
        int newCenterZ = playerChunkPos.field_9180;
        int newViewDistance = FakeChunkManager.client.field_1690.field_1870;
        this.chunkTracker.update(newCenterX, newCenterZ, newViewDistance, chunkPos -> {
            this.cancelLoad(chunkPos);
            this.toBeUnloaded.put(chunkPos, time);
            this.unloadQueue.add((class_3545<Long, Long>)new class_3545((Object)chunkPos, (Object)time));
        }, chunkPos -> {
            int x = class_1923.method_8325((long)chunkPos);
            int z = class_1923.method_8332((long)chunkPos);
            this.toBeUnloaded.remove(chunkPos);
            if (this.clientChunkManager.method_2857(x, z, class_2806.field_12803, false) != null) {
                return;
            }
            LoadingJob loadingJob = new LoadingJob(x, z);
            this.loadingJobs.put(chunkPos, (Object)loadingJob);
            loadExecutor.execute(loadingJob);
        });
        long unloadTime = time - (long)config.getUnloadDelaySecs() * 1000L;
        int countSinceLastThrottleCheck = 0;
        while ((next = this.unloadQueue.pollFirst()) != null) {
            long chunkPos2 = (Long)next.method_15442();
            long queuedTime = (Long)next.method_15441();
            if (queuedTime > unloadTime) {
                this.unloadQueue.addFirst(next);
                break;
            }
            long actualQueuedTime = this.toBeUnloaded.remove(chunkPos2);
            if (actualQueuedTime != queuedTime) {
                if (actualQueuedTime == 0L) continue;
                this.toBeUnloaded.put(chunkPos2, actualQueuedTime);
                continue;
            }
            this.unload(class_1923.method_8325((long)chunkPos2), class_1923.method_8332((long)chunkPos2), false);
            if (countSinceLastThrottleCheck++ <= 10) continue;
            countSinceLastThrottleCheck = 0;
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
        ObjectIterator loadingJobsIter = this.loadingJobs.values().iterator();
        block3: while (loadingJobsIter.hasNext()) {
            LoadingJob loadingJob = (LoadingJob)loadingJobsIter.next();
            while (loadingJob.result == null) {
                if (!blocking) continue block3;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            loadingJobsIter.remove();
            client.method_16011().method_15396("loadFakeChunk");
            loadingJob.complete();
            client.method_16011().method_15407();
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
    }

    public void loadMissingChunksFromCache() {
        int orgViewDistance = FakeChunkManager.client.field_1690.field_1870;
        FakeChunkManager.client.field_1690.field_1870 = 0;
        try {
            this.update(false, () -> false);
        }
        finally {
            FakeChunkManager.client.field_1690.field_1870 = orgViewDistance;
        }
        this.update(false, () -> false);
    }

    public boolean shouldBeLoaded(int x, int z) {
        return this.chunkTracker.isInViewDistance(x, z);
    }

    @Nullable
    private class_3545<class_2487, FakeChunkStorage> loadTag(int x, int z) {
        class_1923 chunkPos = new class_1923(x, z);
        try {
            class_2487 tag = this.storage.loadTag(chunkPos);
            if (tag != null) {
                return new class_3545((Object)tag, (Object)this.storage);
            }
            if (this.fallbackStorage != null && (tag = this.fallbackStorage.loadTag(chunkPos)) != null) {
                return new class_3545((Object)tag, (Object)this.fallbackStorage);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void load(int x, int z, class_2487 tag, FakeChunkStorage storage) {
        Supplier<class_2818> chunkSupplier = storage.deserialize(new class_1923(x, z), tag, (class_1937)this.world);
        if (chunkSupplier == null) {
            return;
        }
        this.load(x, z, chunkSupplier.get());
    }

    protected void load(int x, int z, class_2818 chunk) {
        this.fakeChunks.put(class_1923.method_8331((int)x, (int)z), (Object)chunk);
        this.world.method_23782(new class_1923(x, z));
        for (int i = this.world.method_32891(); i < this.world.method_31597(); ++i) {
            this.world.method_18113(x, i, z);
        }
        this.clientChunkManagerExt.bobby_onFakeChunkAdded(x, z);
    }

    public boolean unload(int x, int z, boolean willBeReplaced) {
        long chunkPos = class_1923.method_8331((int)x, (int)z);
        this.cancelLoad(chunkPos);
        class_2818 chunk = (class_2818)this.fakeChunks.remove(chunkPos);
        if (chunk != null) {
            class_3568 lightingProvider = this.clientChunkManager.method_12130();
            ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9282));
            ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9284));
            for (int i = 0; i < chunk.method_12006().length; ++i) {
                int y = this.world.method_31604(i);
                if (blockLightProvider != null) {
                    blockLightProvider.bobby_removeSectionData(class_4076.method_18685((int)x, (int)y, (int)z));
                }
                if (skyLightProvider == null) continue;
                skyLightProvider.bobby_removeSectionData(class_4076.method_18685((int)x, (int)y, (int)z));
            }
            this.clientChunkManagerExt.bobby_onFakeChunkRemoved(x, z);
            return true;
        }
        return false;
    }

    private void cancelLoad(long chunkPos) {
        LoadingJob loadingJob = (LoadingJob)this.loadingJobs.remove(chunkPos);
        if (loadingJob != null) {
            loadingJob.cancelled = true;
        }
    }

    private static String getCurrentWorldOrServerName() {
        class_1132 integratedServer = client.method_1576();
        if (integratedServer != null) {
            return integratedServer.method_27728().method_150();
        }
        if (client.method_1589()) {
            return "realms";
        }
        class_642 serverInfo = client.method_1558();
        if (serverInfo != null) {
            return serverInfo.field_3761.replace(':', '_');
        }
        return "unknown";
    }

    public String getDebugString() {
        return "F: " + this.fakeChunks.size() + " L: " + this.loadingJobs.size() + " U: " + this.toBeUnloaded.size();
    }

    public Collection<class_2818> getFakeChunks() {
        return this.fakeChunks.values();
    }

    private class LoadingJob
    implements Runnable {
        private final int x;
        private final int z;
        private volatile boolean cancelled;
        private volatile Optional<Supplier<class_2818>> result;

        public LoadingJob(int x, int z) {
            this.x = x;
            this.z = z;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            this.result = Optional.ofNullable(FakeChunkManager.this.loadTag(this.x, this.z)).map(it -> ((FakeChunkStorage)((Object)((Object)it.method_15441()))).deserialize(new class_1923(this.x, this.z), (class_2487)it.method_15442(), (class_1937)FakeChunkManager.this.world));
        }

        public void complete() {
            this.result.ifPresent(it -> FakeChunkManager.this.load(this.x, this.z, (class_2818)it.get()));
        }
    }
}

